<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Blogs extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		if(isset($_POST) && !empty($_POST)) {
	        if(!isset($_SERVER['HTTP_REFERER'])) {
                die('Direct Access Not Allowed!!');
	        }
	    }
		$this->load->library('ts_functions');
        $this->theme = $this->ts_functions->current_theme();
	}

	public function index()
	{
		
	   $this->load->library('ci_pagination');
		$data_per_page = 12;
		$current_key = 0;
		if(isset($_POST['ci_pagination_key'])){
			$current_key = $_POST['ci_pagination_key'];
		}
		if(isset($_GET['category'])){
		$category_data=$this->DatabaseModel->access_database('ts_blog_category','select','',array('blog_category_slug'=>$_GET['category']));
		if(empty($category_data)){
			redirect(base_url().'blogs');
		}
		$catid=$category_data[0]['blog_category_id'];
		$data['count_total'] = $count_total = $this->DatabaseModel->aggregate_data('ts_blogs' , 'blog_id' , 'COUNT',array('blog_category'=>$catid));
		$data['pagination_data'] = $this->ci_pagination->pagination_data($count_total, $current_key , $data_per_page);
		$data['blog_list'] = $this->DatabaseModel->select_data('*' , 'ts_blogs' ,array('blog_category'=>$catid) , array($data_per_page,$current_key),'',array('blog_id','DESC'));
		}else{
		$data['count_total'] = $count_total = $this->DatabaseModel->aggregate_data('ts_blogs' , 'blog_id' , 'COUNT',array('blog_status'=>1));
		$data['pagination_data'] = $this->ci_pagination->pagination_data($count_total, $current_key , $data_per_page);
		$data['blog_list'] = $this->DatabaseModel->select_data('*' , 'ts_blogs' ,array('blog_status'=>1) , array($data_per_page,$current_key),'',array('blog_id','DESC'));
		}
		$data['current_key'] = $current_key;
		$data['blog_categories'] =$this->DatabaseModel->access_database('ts_blog_category','select', '' , array('blog_category_status'=>1));
		$data['basepath'] = base_url();
		
		$data['page_seo']=array('seo_title'=>$this->ts_functions->getlanguage('blogtext','menus','solo'),'seodescr'=>'Our Blogs','seo_keywords'=>'','seo_Image'=>'');
	    $this->load->view('themes/'.$this->theme.'/home/include/home_header',$data);
        $this->load->view('themes/'.$this->theme.'/home/include/menu_header',$data);
        $this->load->view('themes/'.$this->theme.'/home/blogs',$data);
        $this->load->view('themes/'.$this->theme.'/home/include/home_footer',$data);
	}
	public function blog_post($blog_slug=""){
		if($blog_slug==""){
			redirect(base_url().'blogs');
		}
		$blog_detail=$this->DatabaseModel->access_database('ts_blogs','select', '' , array('blog_slug'=>$blog_slug));
		
		if(!empty($blog_detail)){
			$blog_id=$blog_detail[0]['blog_id'];
			$data['comments']=$this->DatabaseModel->access_database('ts_comments','select', '' , array('comment_prodid'=>$blog_id,'comment_parent'=>0,'comment_type'=>'blog'));
		$data['comment_count']=$this->DatabaseModel->aggregate_data('ts_comments' , 'comment_id' , 'COUNT',array('comment_prodid'=>$blog_id,'comment_type'=>'blog'));
		$data['blog_detail']=$blog_detail;
		$data['blog_categories'] =$this->DatabaseModel->access_database('ts_blog_category','select', '' , array('blog_category_status'=>1));
		$data['basepath'] = base_url();
	    $this->load->view('themes/'.$this->theme.'/home/include/home_header',$data);
        $this->load->view('themes/'.$this->theme.'/home/include/menu_header',$data);
        $this->load->view('themes/'.$this->theme.'/home/single_blog',$data);
        $this->load->view('themes/'.$this->theme.'/home/include/home_footer',$data);
		}else{
			redirect(base_url().'blogs');
		}
	}
}